# PDF-O-Matic is copyright (c) 2009, Brett Neumeier.
#
# PDF-O-Matic may be used under the terms of the GPL.  See
# COPYING.GPL, provided in this distribution, for full details.
#
# DOJ and CompNet Design, Inc., are granted a perpetual license to
# use, extend, modify, and redistribute the PDF-O-Matic software as
# they wish, without restriction.

class CharacterSheetFifth < TemplateOverlay

  def initialize(filename, resource_dir = nil)
    super(filename, 'charsheet5', resource_dir)
  end

  def additional_first_page_blocks
    combat_info_block
  end

  def logo_file
    'logo5.stamp'
  end

  def continuation_page_item_position
    694
  end

  def header_block
    render_header_block(14, 1, 135, 747)
  end

  def character_and_campaign_info
    text_left_at(char['character_name'], 106, 732)
    text_centered_at(char['height'], 89, 716, 45)
    text_centered_at(char['weight'], 176, 716, 50)
    text_centered_at(char['hair_color'], 93, 700, 35)
    text_centered_at(char['eye_color'], 181, 700, 40)
    text_trimmed_at(char['campaign'], 478, 732, 100)
    text_left_at(char['genre'], 433, 716)
    text_left_at(char['gamemaster'], 459, 700)
  end

  def characteristic_block
    add_characteristic_skill_levels
    ypos = 655
    %w[ str dex con body int ego pre com ].each { |c|
      text_centered_at(char["#{c}_val"], 53, ypos)
      text_centered_at(char["#{c}_pts"], 191, ypos)
      text_centered_at(char["#{c}_roll"].gsub(' ',''), 227, ypos)
      ypos -= 16
    }

    ypos = 511
    %w[ pd ed spd rec end stun ].each { |c|
      text_centered_at(char["#{c}_val"], 53, ypos)
      text_centered_at(char["#{c}_pts"], 191, ypos)
      ypos -= 16
    }

    # Notes can't be handled in any kind of consistent way, since
    # they vary entirely by characteristic.
    text_centered_twolines_at(char['str_damage'].gsub(/d6/,''), 306, 655, 20)
    text_centered_twolines_at(char['str_lift'].gsub(/\.0/,''), 363, 655, 28)
    text_centered_at(char['str_end'], 405.5, 655, 11)
    text_centered_at(char['ocv'], 275, 639)
    text_centered_at(char['dcv'], 365, 639)
    text_centered_at(char['per_roll'], 318, 591)
    text_centered_at(char['ecv'], 295, 575)
    text_centered_at(char['pre_attack'].gsub(/d6/,'').sub(' / ','/'), 343, 559)
    text_centered_at(char['r_pd'], 308, 511)
    text_centered_at(char['pd'], 366, 511)
    text_centered_at(char['r_ed'], 308, 495)
    text_centered_at(char['ed'], 366, 495)
    pdf.font_size(12) {
      text_centered_at(char['characteristic_total_pts'], 227, 431)
    }
    print_phases
  end

  def phase_y_position
    481.5
  end

  def phase_x_positions
    { 1 => 279, 2 => 288.5, 3 => 298, 4 => 308, 5 => 317.2, 
      6 => 327, 7 => 336.5, 8 => 346.4, 9 => 355.7, 10 => 368.2, 
      11 => 382.2, 12 => 397 }
  end

  def experience_block
    ypos = 395
    %w[ xp_earned xp_spent xp_unspent base_points disad_points ].each { |x|
      text_centered_at(char[x], 383, ypos)
      ypos -= 16
    }
  end

  def movement_block
    ypos = 274
    horiz_noncom = char['horiz_leap_noncom'] || '0"'
    char['vert_leap_noncom'] = horiz_to_vertical(horiz_noncom)
    %w[ running swimming horiz_leap vert_leap ].each { |m|
      text_centered_at(char[m], 352, ypos)
      text_centered_at(char["#{m}_noncom"], 390, ypos)
      ypos -= 16
    }
    text_centered_at(char['horiz_leap_base'].chomp('"'), 314, 242)
    text_centered_at(char['vert_leap_base'].chomp('"'), 313, 226)
    ypos = 210
    movement_powers_to_show.each { |mp|
      text_left_at(mp.capitalize, 270, ypos, 60)
      text_centered_at(char[mp], 352, ypos)
      text_centered_at(char["#{mp}_noncom"], 390, ypos)
      ypos -= 16
    }
  end

  def defense_block
    ypos = 274
    %w[ pd r_pd ed r_ed mental_def flash_def power_def ].each { |d|
      text_centered_at(char[d], 160, ypos)
      ypos -= 16
    }
    if Enumerable === char['powers']
      fd = char['powers'].detect { |p| p['xmlid'] == 'FLASHDEFENSE' }
      if fd
        group = fd['option'].sub(/ Group/,'')
        text_centered_at(group, 115, 194, 40)
        text_centered_at(fd['levels'], 160, 194)
      end
    end
  end

  def combat_info_block
    text_centered_at(char['ocv'], 490, 670)
    text_centered_at(char['dcv'], 563, 670)
    text_centered_at(char['ocv'], 490, 606)
    text_centered_at(char['dcv'], 563, 606)
    return unless Enumerable === char['skills']
    overall = char['skills'].detect {|s|
      s['xmlid'] == 'SKILL_LEVELS' && s['option_id'] == 'OVERALL'
    }
    if overall
      text_left_at(overall['text'], 513, 590)
    end
    levels = char['skills'].select {|s|
      s['xmlid'] =~ /(COMBAT|PENALTY_SKILL)_LEVELS$/
    }
    if levels
      levels.sort! { |a,b| b['cost'].to_i <=> a['cost'].to_i }
      displaytext = levels.map { |l|
        l['text'].sub(/.*: */, '').sub(/ *\([0-9]+ Active Points\)/,'')
      }
      text_left_at(displaytext[0], 432, 574, 140) if levels.size > 0
      text_left_at(displaytext[1], 432, 558, 140) if levels.size > 1
    end
  end

  def skills
    region = ItemListRegion.new(37, 47, 27, 656, 209, 60)
    render_item_list(644, 104, @sb, [region]) { |xpos, ypos, linedrop, item|
      col_widths = [ 18, 120, 20 ]
      ypos = skill_line(item, xpos, ypos, linedrop, col_widths)
      ypos -= linedrop
    }
    pdf.font_size(12) { text_centered_at(char['skill_etc_points'], 47, 52, 20) }
  end

  def powers
    region = ItemListRegion.new(27, 233, 220, 656, 600, 208)
    render_item_list(644, 203, @pb, [region]) { |xpos, ypos, linedrop, item|
      col_widths = [ 20, 86, 210, 20 ]
      ypos = power_line(item, xpos, ypos, linedrop, col_widths)
      ypos -= linedrop
    }
    pdf.font_size(12) { text_centered_at(char['power_points'], 233, 196, 20) }
  end

  def disads
    regions = [ 
      ItemListRegion.new(7, 233, 220, 150, 410, 30),
      ItemListRegion.new(6, 420, 410, 150, 600, 50) ]
    render_item_list(139, 123, @db, regions) { |xpos, ypos, linedrop, item|
      col_widths = [ 17, 125, 20 ]
      ypos = disadvantage_line(item, xpos, ypos, linedrop, col_widths)
      ypos -= linedrop
    }
    pdf.font_size(12) { text_centered_at(char['disad_points'], 419, 43, 20) }
  end

  def combat_maneuvers_block
    region = ItemListRegion.new(5, 432, 430, 412, 590, 347)
    render_item_list(412, 999, @mb, [region], 15) { |xpos, ypos, linedrop, item|
      text_trimmed_at(item.name, xpos, ypos, 37)
      text_centered_at(item.phase, xpos + 44, ypos, 10)
      text_centered_at(item.ocv, xpos + 61, ypos, 10)
      text_centered_at(item.dcv, xpos + 79, ypos, 10)
      pdf.font_size(6.5) { text_trimmed_at(item.text, xpos + 88, ypos, 58) }
      ypos -= linedrop
    }
  end

  def continuation_page_header
    pdf.stamp_at('Logo', [440, 700])
    header_widths = []
    pdf.fill_color(0, 0, 0, 100)
    pdf.font(resource(bold_font), :size => 12) {
      text_left_at('Character Name:', 36, 747)
      header_widths << width_of('Character Name:')
    }
    pdf.font(resource(medium_font), :size => 12) {
      text_left_at('Player Name:', 36, 731)
      header_widths << width_of('Player Name:')
      text_left_at('Campaign Name:', 36, 715)
      header_widths << width_of('Campaign Name:')
    }
    val_xpos = 36 + header_widths.max + width_of('m')
    primary_color
    text_left_at(char['character_name'], val_xpos, 747)
    text_left_at(char['player_name'], val_xpos, 731)
    text_left_at(char['campaign'], val_xpos, 715)
  end

  def skills_continued(ypos)
    col_widths = [ 17, 500, 20 ]
    return continued_block(ypos, col_widths, @sb)
  end

  def powers_continued(ypos)
    col_widths = [ 20, 101, 387, 20 ]
    return continued_block(ypos, col_widths, @pb)
  end

  def disadvantages_continued(ypos)
    col_widths = [ 15, 500, 10 ]
    return continued_block(ypos, col_widths, @db)
  end

  def continued_block(ypos, col_widths, itembox)
    return ypos if ypos < 106
    ypos = send("#{itembox.contents}_continued_heading".to_sym, ypos)
    rows_remaining = (ypos - 36) / 13
    text_width = col_widths.max
    items = itembox.pull_items_for_region(rows_remaining, text_width)
    items.each { |item|
      xpos = 44
      ypos = send("#{itembox.contents}_line".to_sym, item, xpos,
                  ypos, 10, col_widths)
      ypos -= 13
    }
    ypos - 6
  end

  def continued_heading(name, ypos)
    color(0,0,0,100)
    pdf.rectangle([36, ypos], 540, 12)
    pdf.fill
    color(0,0,0,0)
    ypos -= 11
    pdf.font(resource(bold_font), :size => 12) {
      pdf.text(name + ' (continued)', :at => [ 38, ypos ])
    }
    ypos -= 15
    color(0,0,0,100)
    pdf.font(resource(bold_font), :size => 10) { yield(ypos) }
    primary_color
    ypos - 12
  end

  def skill_continued_heading(ypos)
    ypos = continued_heading('SKILLS, PERKS, AND TALENTS', ypos) { |y|
      text_centered_at('Cost', 45, y, 20)
      text_left_at('Name', 63, y, 509)
      text_centered_at('Roll', 565, y, 20)
    }
  end

  def power_continued_heading(ypos)
    ypos = continued_heading('POWERS AND EQUIPMENT', ypos) { |y|
      text_centered_at('Cost', 46, y, 20)
      text_left_at('Name', 66, y, 100)
      text_left_at('Power/Equipment', 169, y, 387)
      text_centered_at('END', 566, y, 20)
    }
  end

  def disadvantage_continued_heading(ypos)
    ypos = continued_heading('DISADVANTAGES', ypos) { |y|
      text_centered_at('Cost', 45, y, 20)
      text_left_at('Disadvantage', 63, y, 509)
      text_centered_at('Roll', 565, y, 20)
    }
  end

end
